package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.biz.RequestLocationDocument;
import gov.va.vinci.dart.db.RequestLocationDocumentDAO;

public class RequestLocationDocumentDAOMock implements RequestLocationDocumentDAO {

	private static HashMap<Integer,RequestLocationDocument> IDHash = new HashMap<Integer,RequestLocationDocument>();
	private static boolean initialized = false;
	private static int idCounter = 1;
	
	@Override
	public void save(RequestLocationDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
	
		initializeDocHash();
		
		if (document.getId() == 0) {
			document.setId(idCounter++);
		}
		
		IDHash.put(document.getId(), document);
	}

	@Override
	public void delete(RequestLocationDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		initializeDocHash();

		IDHash.remove(document.getId());
	}

	@Override
	public List<RequestLocationDocument> listByRequestId(int requestId) {
		List<RequestLocationDocument> result = new ArrayList<RequestLocationDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestLocationDocument rald = IDHash.get(id);
			if (rald.getRequestId() == requestId) {
				result.add(rald);
			}
		}

		return result;	
	}

	@Override
	public List<RequestLocationDocument> listByDocumentId(int documentId) {
		List<RequestLocationDocument> result = new ArrayList<RequestLocationDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestLocationDocument rald = IDHash.get(id);
			if (rald.getDocumentId() == documentId) {
				result.add(rald);
			}
		}

		return result;	
	}
	
	@Override
	public List<RequestLocationDocument> listByRequestAndLocationId(final int requestId, final int locationId) {
		List<RequestLocationDocument> result = new ArrayList<RequestLocationDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestLocationDocument rald = IDHash.get(id);
			if (rald.getRequestId() == requestId && rald.getLocationId() == locationId) {	//match both the requestId and the locationId
				result.add(rald);
			}
		}

		return result;	
	}
	
	@Override
	public List<RequestLocationDocument> listActiveDocsByRequestAndLocationId(final int requestId, final int locationId) {
		List<RequestLocationDocument> result = new ArrayList<RequestLocationDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestLocationDocument rald = IDHash.get(id);
			
			if( rald.isActive() == true ) {	//active document
				if (rald.getRequestId() == requestId && rald.getLocationId() == locationId) {	//match both the requestId and the locationId
					result.add(rald);
				}
			}//end if
		}

		return result;	
	}

	
	private void initializeDocHash() {
		if (initialized == true) {
			return;
		}
		initialized = true;
	}

}
